package com.jiamai.live.api.result;

import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@Data
public class RoomStatusResult implements Serializable {

    /**
     * 是否观众
     *
     * 0-不是
     * 1-是
     */
    private Byte visitor;

    /**
     * 直播间状态
     * 1-已结束
     * 2-待开播
     * 3-直播中
     */
    private Byte roomStatus;

    /**
     * 1-无需申请
     * 2-未申请客户
     * 3-申请被拒绝客户
     * 4-申请通过客户（废弃）
     * 5-申请中客户
     */
    private Integer customerType;

    /**
     * 是否是助手
     * 0-否
     * 1-是
     */
    private Integer assist;

}
