/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.enums;

import java.util.Objects;

public enum EnumRecordStatus {
    UNKNOWN(-1, "\u672a\u77e5"),
    NOT_OPEN(0, "\u672a\u516c\u5f00"),
    OPEN(1, "\u516c\u5f00");

    private final byte code;
    private final String desc;

    private EnumRecordStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumRecordStatus getByCode(Byte code) {
        for (EnumRecordStatus e : EnumRecordStatus.values()) {
            if (!Objects.equals(e.getCode(), code)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static boolean isNotOpen(Byte code) {
        return Objects.equals(EnumRecordStatus.NOT_OPEN.code, code);
    }

    public static boolean isOpen(Byte code) {
        return Objects.equals(EnumRecordStatus.OPEN.code, code);
    }

    public byte getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

