/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.enums;

import java.util.Objects;

public enum EnumOperatorType {
    UNKNOWN(-1, "\u672a\u77e5"),
    BAN(1, "\u7981\u8a00"),
    CLEAN_BAN(2, "\u89e3\u7981"),
    KICKOFF(3, "\u8e22\u4eba"),
    CLEAN_KICKOFF(4, "\u89e3\u9664\u8e22\u4eba");

    private final byte code;
    private final String desc;

    private EnumOperatorType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumOperatorType getByCode(Byte code) {
        for (EnumOperatorType e : EnumOperatorType.values()) {
            if (!Objects.equals(e.getCode(), code)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static boolean isBan(Byte code) {
        return Objects.equals(EnumOperatorType.BAN.code, code);
    }

    public static boolean isClearBan(Byte code) {
        return Objects.equals(EnumOperatorType.CLEAN_BAN.code, code);
    }

    public static boolean isKickOff(Byte code) {
        return Objects.equals(EnumOperatorType.KICKOFF.code, code);
    }

    public static boolean isCleanKickOff(Byte code) {
        return Objects.equals(EnumOperatorType.CLEAN_KICKOFF.code, code);
    }

    public byte getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

