/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.enums;

import java.util.Objects;

public enum EnumShowStatus {
    UNKNOWN(-1, "\u672a\u77e5"),
    NOT_SHOW(0, "\u672a\u63ed\u5e55"),
    SHOW(1, "\u5df2\u63ed\u5e55");

    private final byte code;
    private final String desc;

    private EnumShowStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumShowStatus getByCode(Byte code) {
        for (EnumShowStatus e : EnumShowStatus.values()) {
            if (!Objects.equals(e.getCode(), code)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static boolean isShow(Byte code) {
        return Objects.equals(EnumShowStatus.SHOW.code, code);
    }

    public static boolean isShow(EnumShowStatus type) {
        return Objects.equals((Object)SHOW, (Object)type);
    }

    public static boolean isNotShow(Byte code) {
        return Objects.equals(EnumShowStatus.NOT_SHOW.code, code);
    }

    public static boolean isNotShow(EnumShowStatus type) {
        return Objects.equals((Object)NOT_SHOW, (Object)type);
    }

    public byte getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

