/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.result.base;

import com.youqian.api.request.PageRequest;
import com.youqian.api.response.PageResult;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PageResultV2<T>
extends PageResult<T>
implements Serializable {
    private Integer unDoApplyCount;

    public static <T> PageResultV2<T> create(List<T> data, Integer pageNo, Integer pageSize, Long total) {
        PageResultV2<T> pageResult = new PageResultV2<T>();
        pageResult.setList(data);
        pageResult.setPageNo(pageNo);
        pageResult.setPageSize(pageSize);
        pageResult.setTotal(total);
        if (CollectionUtils.isEmpty(data)) {
            pageResult.setHasNext(false);
        } else if (pageSize > data.size()) {
            pageResult.setHasNext(false);
        } else {
            pageResult.setHasNext(true);
        }
        long totalPageNo = total % (long)pageSize.intValue() == 0L ? total / (long)pageSize.intValue() : total / (long)pageSize.intValue() + 1L;
        pageResult.setTotalPageNo((int)totalPageNo);
        return pageResult;
    }

    public static <T> PageResultV2<T> create(List<T> data, PageRequest pageRequest, Long total) {
        return PageResultV2.create(data, pageRequest.getPageNo(), pageRequest.getPageSize(), total);
    }

    public Integer getUnDoApplyCount() {
        return this.unDoApplyCount;
    }

    public void setUnDoApplyCount(Integer unDoApplyCount) {
        this.unDoApplyCount = unDoApplyCount;
    }

    public String toString() {
        return "PageResultV2(unDoApplyCount=" + this.getUnDoApplyCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResultV2)) {
            return false;
        }
        PageResultV2 other = (PageResultV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$unDoApplyCount = this.getUnDoApplyCount();
        Integer other$unDoApplyCount = other.getUnDoApplyCount();
        return !(this$unDoApplyCount == null ? other$unDoApplyCount != null : !((Object)this$unDoApplyCount).equals(other$unDoApplyCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResultV2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $unDoApplyCount = this.getUnDoApplyCount();
        result = result * 59 + ($unDoApplyCount == null ? 43 : ((Object)$unDoApplyCount).hashCode());
        return result;
    }
}

