/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.enums;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum EnumVideoFormat {
    UNKNOWN(0, "\u672a\u77e5"),
    M3U8(1, "m3u8"),
    MP4(2, "mp4");

    private final byte code;
    private final String suffix;

    private EnumVideoFormat(byte code, String suffix) {
        this.code = code;
        this.suffix = suffix;
    }

    public static EnumVideoFormat getByCode(Byte code) {
        for (EnumVideoFormat e : EnumVideoFormat.values()) {
            if (!Objects.equals(e.getCode(), code)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static EnumVideoFormat getBySuffix(String url) {
        if (StringUtils.isBlank((String)url)) {
            return UNKNOWN;
        }
        String lowerCase = url.toLowerCase();
        for (EnumVideoFormat e : EnumVideoFormat.values()) {
            if (!lowerCase.endsWith(e.suffix)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static boolean isM3U8(Byte code) {
        return Objects.equals(M3U8.getCode(), code);
    }

    public static boolean isMP4(Byte code) {
        return Objects.equals(MP4.getCode(), code);
    }

    public byte getCode() {
        return this.code;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

