/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class DateSerializer
extends JsonSerializer<Date> {
    private static final FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"MM\u6708dd\u65e5 \u4e0a\u5348HH:mm");

    public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeString("");
            return;
        }
        String format = fastDateFormat.format(value);
        Calendar calendar = new Calendar.Builder().setInstant(value).build();
        int i = calendar.get(11);
        if (i >= 12) {
            format = format.replaceAll("\u4e0a\u5348", "\u4e0b\u5348");
        }
        gen.writeString(format);
    }
}

