package com.jiamai.live.api.dto;

import com.youqian.api.response.LiveGoodsListResult;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * Created by hong
 * time 2020/12/2.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RoomGoodsDto extends LiveGoodsListResult {

    private static final long serialVersionUID = 1627512350805930153L;

    /**
     * 直播商品ID
     * not null default = 0
     */
    private Long liveGoodsId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 讲解中状态，0-非讲解中/1-讲解中
     */
    private Byte explain;

    /**
     * 是否是直播间爆品，0-否/1-是
     */
    private Byte liveHot;

    /**
     * 商品是否揭幕，0-未揭幕/1-已揭幕
     */
    private Byte showStatus;

    /**
     * 商品揭幕时间
     */
    private Date showTime;

    /**
     * 短视频地址
     */
    private String videoUrl;

    /**
     * 短视频生成状态，0-无短视频/1-生成中/2-生成完成
     * @see com.jiamai.live.api.enums.EnumGoodsVideoStatus
     */
    private Byte videoStatus;

    /**
     * 短视频生成JobId
     */
    private String jobId;

    /**
     * 短视频开始时间(基于原视频)
     */
    private Integer videoSeek;

    /**
     * 短视频时长
     */
    private Integer videoDuration;


    /**
     * 商品图片数量
     */
    private Integer countProductPictures;

    /**
     * 下一个视频id
     * not null default = 0
     */
    private Long nextRoomGoodsId;

    /**
     * 上一个视频id
     * not null default = 0
     */
    private Long lastRoomGoodsId;

    /**
     * 直播回放地址
     */
    private String recordUrl;
}
