package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播商品表
 * @author youqian mybatis generator 
 * 2020-04-21
 */
@Data
public class LiveGoodsDto implements Serializable {
    private static final long serialVersionUID = 15874510814008731L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播商品ID
     * not null default = 0
     */
    private Long liveGoodsId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商品直播序号
     * not null default = 0
     */
    private Integer liveOrder;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 讲解中状态，0-非讲解中/1-讲解中
     */
    private Byte explain;

    /**
     * 是否是直播间爆品，0-否/1-是
     */
    private Byte liveHot;

    /**
     * 商品是否揭幕，0-未揭幕/1-已揭幕
     */
    private Byte showStatus;

    /**
     * 商品揭幕时间
     */
    private Date showTime;

    /**
     * 短视频地址
     */
    private String videoUrl;

    /**
     * 短视频生成状态，0-无短视频/1-生成中/2-生成完成
     * @see com.jiamai.live.api.enums.EnumGoodsVideoStatus
     */
    private Byte videoStatus;

    /**
     * 短视频生成JobId
     */
    private String jobId;

    /**
     * 短视频开始时间(基于原视频)
     */
    private Integer videoSeek;

    /**
     * 短视频时长
     */
    private Integer videoDuration;
}