package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播前评论
 * @author youqian mybatis generator 
 * 2020-08-26
 */
@Data
public class LivePreCommentDto implements Serializable {
    private static final long serialVersionUID = 15984091989254654L;

    /**
     * 业务主键ID
     * not null default = 0
     */
    private Long livePreCommentId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 创建人名字
     * not null default = 0
     */
    private Long userId;

    /**
     * 内容
     * max length = 100
     * not null default = 
     */
    private String content;

    /**
     * 客户名称
     * max length = 100
     * not null default = 
     */
    private String customerName;

    /**
     * 用户名称
     * max length = 100
     * not null default = 
     */
    private String userName;

    /**
     * 头像
     * max length = 300
     * not null default = 
     */
    private String avatarUrl;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}