package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/5/11
 * @description 小程序推流清晰度
 */
@Getter
public enum EnumClarity {

    SD((byte) 1, "标清"),
    HD((byte) 2, "高清"),
    FHD((byte) 3, "超清"),
    ;

    private byte code;

    private String desc;

    EnumClarity(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumClarity getByCode(Byte code) {
        for (EnumClarity e : EnumClarity.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return FHD;
    }
}
