package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/24
 * @description 商品揭幕状态
 */
@Getter
public enum EnumGoodsShowType {

    /**
     *
     */
    UNKNOWN((byte) -1, "未知"),
    ALL_SHOW((byte) 0, "无需揭秘"),
    WAIT_SHOW((byte) 1, "陆续揭秘"),
    ;

    private final byte code;

    private final String desc;

    EnumGoodsShowType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumGoodsShowType getByCode(Byte code) {
        for (EnumGoodsShowType e : EnumGoodsShowType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    /**
     * 是否是ALL_SHOW
     */
    public static boolean isAllShow(Byte code) {
        return Objects.equals(ALL_SHOW.code, code);
    }

    /**
     * 是否是ALL_SHOW
     */
    public static boolean isAllShow(EnumGoodsShowType type) {
        return Objects.equals(ALL_SHOW, type);
    }

    /**
     * 是否是WAIT_SHOW
     */
    public static boolean isWaitShow(Byte code) {
        return Objects.equals(WAIT_SHOW.code, code);
    }

    /**
     * 是否是WAIT_SHOW
     */
    public static boolean isWaitShow(EnumGoodsShowType type) {
        return Objects.equals(WAIT_SHOW, type);
    }
}
