package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/12/2
 * @description
 */
@Getter
public enum EnumGoodsVideoStatus {

    /**
     *
     */
    NO_VIDEO((byte) 0, "无短视频"),
    IN_GEN((byte) 1, "短视频生成中"),
    GEN((byte) 2, "短视频生成完成"),
    GEN_FAIR((byte) 3, "短视频生成失败"),
    GEN_CANCEL((byte) 4, "短视频生成取消"),
    ;

    private final byte code;

    private final String desc;

    EnumGoodsVideoStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumGoodsVideoStatus getByCode(Byte code) {
        for (EnumGoodsVideoStatus e : EnumGoodsVideoStatus.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        throw new RuntimeException("code不存在");
    }
}
