package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/23
 * @description 直播间昵称脱敏
 */
@Getter
public enum EnumHideName {

    /**
     * 直播间昵称脱敏
     */
    NOT_HIDE((byte) 0, "未脱敏"),
    HIDE((byte) 1, "脱敏");

    private final byte code;
    private final String desc;

    EnumHideName(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isNotHide(Byte b) {
        return Objects.equals(NOT_HIDE.code, b);
    }

    public static boolean isHide(Byte b) {
        return Objects.equals(HIDE.code, b);
    }

}
