package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/23
 * @description
 */
@Getter
public enum EnumIntroduce {

    UNKNOWN((byte) -1, "未知"),
    NOT_INTRODUCE((byte) 0, "介绍"),
    IN_INTRODUCE((byte) 1, "讲解中"),
    ;

    private byte code;

    private String desc;

    EnumIntroduce(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumIntroduce getByCode(Byte code) {
        for (EnumIntroduce e : EnumIntroduce.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

}
