package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/24
 * @description
 */
@Getter
public enum EnumInviteType {

    UNKNOWN((byte) 0, "未知"),
    LIVER((byte) 1, "邀请主播"),
    ASSIST((byte) 2, "邀请助手"),
    ;

    private final byte code;

    private final String desc;

    EnumInviteType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumInviteType getByCode(Byte code) {
        for (EnumInviteType e : EnumInviteType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    public static boolean isInviteLiver(Byte b) {
        return Objects.equals(LIVER.code, b);
    }

    public static boolean isInviteAssist(Byte b) {
        return Objects.equals(ASSIST.code, b);
    }
}
