package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/12/2
 * @description
 */
@Getter
public enum EnumMpsJobStatus {

    UNKNOWN((byte) 0, "未知"),
    SUBMIT((byte) 1, "已提交"),
    SUCCESS((byte) 2, "成功"),
    FAIL((byte) 3, "失败"),
    CANCEL((byte) 4, "取消"),
    ;

    private final byte code;

    private final String desc;

    EnumMpsJobStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumMpsJobStatus getByCode(Byte code) {
        for (EnumMpsJobStatus e : EnumMpsJobStatus.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
