package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/12/2
 * @description
 */
@Getter
public enum EnumMpsJobType {

    UNKNOWN((byte) 0, "未知"),
    TRANS((byte) 1, "转码"),
    SNAPSHOT((byte) 2, "截图"),
    ;

    private final byte code;

    private final String desc;

    EnumMpsJobType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumMpsJobType getByCode(Byte code) {
        for (EnumMpsJobType e : EnumMpsJobType.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
