package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/24
 * @description 商品揭幕状态
 */
@Getter
public enum EnumShowStatus {

    /**
     *
     */
    UNKNOWN((byte) -1, "未知"),
    NOT_SHOW((byte) 0, "未揭幕"),
    SHOW((byte) 1, "已揭幕"),
    ;

    private final byte code;

    private final String desc;

    EnumShowStatus(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static EnumShowStatus getByCode(Byte code) {
        for (EnumShowStatus e : EnumShowStatus.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }

    /**
     * 是否是揭幕状态
     */
    public static boolean isShow(Byte code) {
        return Objects.equals(SHOW.code, code);
    }

    /**
     * 是否是揭幕状态
     */
    public static boolean isShow(EnumShowStatus type) {
        return Objects.equals(SHOW, type);
    }

    /**
     * 是否是未揭幕状态
     */
    public static boolean isNotShow(Byte code) {
        return Objects.equals(NOT_SHOW.code, code);
    }

    /**
     * 是否是未揭幕状态
     */
    public static boolean isNotShow(EnumShowStatus type) {
        return Objects.equals(NOT_SHOW, type);
    }
}
