package com.jiamai.live.api.mq;

import cn.com.duiba.wolf.utils.UUIDUtils;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author xiachenhang
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BackLogEvent implements Serializable {
    private static final long serialVersionUID = 6059053087919715471L;
    /**
     * 待办事项类型
     * @see com.youqian.api.enums.BackLogEnum
     * not null default = 0
     */
    private String code;

    /**
     * 商户Id
     */
    private Long merchantId;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 直播间ID
     */
    private Long liveRoomId;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 订货单ID
     */
    private Long orderMainId;

    /**
     * 完成状态- 订单相关
     */
    private Byte finishStatus;

    /**
     * 请求ID
     */
    private String requestId = UUIDUtils.createSecureUUID();

}
