package com.jiamai.live.api.param;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by hong
 * time 2020/7/25.
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AnnouncementEditParam extends Operator implements Serializable {

    private static final long serialVersionUID = -7678379691854943938L;

    /**
     * 直播间ID
     */
    @Min(1)
    @NotNull
    private Long liveRoomId;

    /**
     * 直播间公告
     */
    private String announcement;


    /**
     * 直播间公告背景色
     */
    private String announcementBackgroundColor;
}
