package com.jiamai.live.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.jiamai.live.api.dto.live.LiveGoodsDto;
import com.jiamai.live.api.dto.live.LiveGoodsStatisticalDto;
import com.jiamai.live.api.dto.live.LiveInfoDto;
import com.jiamai.live.api.dto.live.LiveRoomDto;
import com.jiamai.live.api.dto.live.LiveStatisticalDto;
import com.jiamai.live.api.dto.live.LiveUserFollowDto;
import com.jiamai.live.api.dto.live.LiveWatchDto;
import com.jiamai.live.api.dto.live.MpsJobDto;
import com.jiamai.live.api.enums.EnumCommentType;
import com.jiamai.live.api.param.clue.LiveInfoParam;
import com.jiamai.live.api.param.clue.LiveListParam;
import com.jiamai.live.api.param.clue.LiveStatisticalParam;
import com.jiamai.live.api.request.ActionRequest;
import com.jiamai.live.api.request.LiveDayRequest;
import com.jiamai.live.api.request.LiveGoodsPageRequest;
import com.jiamai.live.api.request.LiveScreenRequest;
import com.jiamai.live.api.request.OrderBillRequest;
import com.jiamai.live.api.request.RoomBuyerPageRequest;
import com.jiamai.live.api.result.HomePageResult;
import com.jiamai.live.api.result.InviteSubResult;
import com.jiamai.live.api.result.LiveDescStatisticalResult;
import com.jiamai.live.api.result.LiveGoodsDataResult;
import com.jiamai.live.api.result.LiveRoomStatusResult;
import com.jiamai.live.api.result.LiveStatisticalDataResult;
import com.jiamai.live.api.result.LiveStatisticalDescDataResult;
import com.jiamai.live.api.result.PageScreenshotResult;
import com.youqian.api.dto.redpack.RedpackDto;
import com.jiamai.live.api.result.LiveStatisticalResult;
import com.jiamai.live.dto.live.LiveWatchExtDto;
import com.youqian.api.dto.raffle.RaffleDto;
import com.youqian.api.response.PageResult;
import com.youqian.auth.api.exception.BizException;
import java.util.List;

/**
 * @author xiachenhang
 * @date 2020/4/21
 * @description
 */
@AdvancedFeignClient
public interface RemoteLiveService {

    /**
     * 根据商户ID组获取所有的直播状态
     * @param merchantIds 商户ID组
     * @return
     * @throws BizException
     */
    List<LiveRoomStatusResult> selectRoomStatusByMerchantIds(List<Long> merchantIds) throws BizException;

    /**
     * 根据商户ID获取直播状态
     * @param merchantId 商户ID
     * @return
     *  @throws BizException
     */
    List<LiveRoomStatusResult> selectRoomStatusByMerchantId(Long merchantId) throws BizException;

    /**
     * 直播间详情
     *
     * @return PageResult<LiveRoomDto>
     * @throws BizException BizException
     */
    PageResult<LiveRoomDto> buyerPageList(RoomBuyerPageRequest request) throws BizException;

    /**
     * 定时任务:推送提醒
     * 主播开播前15分钟推,主播提前开播推
     *  @throws BizException
     */
    void LiveReport() throws BizException;

    /**
     * 发送动作
     * @param request 动作:关注，询价，收藏
     * @param enumComment 直播间动态
     * @throws BizException
     */
    void sendAction(ActionRequest request, EnumCommentType enumComment) throws BizException;

    /**
     * 发送报单
     * @param request 动作:关注，询价，收藏
     * @throws BizException
     */
    void sendOrder(OrderBillRequest request) throws BizException;

    /**
     * 根据LiveRoomId查房间信息
     * @param roomId 房间号ID
     * @return
     * @throws BizException
     */
    LiveRoomDto selectByLiveRoomId(Long roomId) throws BizException;

    /**
     * 根据LiveRoomId组查房间信息
     * @param roomIds 房间号ID
     * @return
     * @throws BizException
     */
    List<LiveRoomDto> selectByLiveRoomIds(List<Long> roomIds) throws BizException;

    /**
     * 定时任务:实时统计开播直播间的用户人次
     */
    void liveUserCountJob();

    /**
     * 查询直播间列表
     * @param liveListParam 直播列表参数
     * @return
     */
    List<LiveRoomDto> selectLiveRoomList(LiveListParam liveListParam);

    /**
     * 查询直播间统计
     * @param liveListParam 直播列表参数
     * @return
     */
    Integer countRoomListTotal(LiveListParam liveListParam);

    List<LiveGoodsDto> selectLiveGoods(Long liveRoomId);

    /**
     * 根据直播房间号查人均观看数据
     */
    LiveStatisticalDto getStatistical(Long liveRoomId) throws BizException;

    /**
     * 根据直播间Id 查商品讲解时长和商品数
     */
    LiveGoodsStatisticalDto getGoodsStatistical(Long liveRoomId) throws BizException;

    LiveInfoDto liveInfo(LiveInfoParam liveInfoParam);

    /**
     * 直播间查询
     *
     * @param liveRoomDto liveRoomDto
     * @return PageResult<LiveRoomDto>
     * @throws BizException 异常
     */
    List<Long> selectLiveRoomId(LiveRoomDto liveRoomDto) throws BizException;

    /**
     * 广播发送红包消息
     * @param redpackDto 红包详情dto
     */
    void sendRedpackMessage(RedpackDto redpackDto);

    /**
     * 广播发送取消红包消息
     * @param redpackDto 红包详情dto
     */
    void sendCancelRedpackMessage(RedpackDto redpackDto);

    /**
     * 广播发送开始发红包消息
     * @param redpackDto 红包详情dto
     */
    void sendStartGrabRedpackMessage(RedpackDto redpackDto);

    /**
     * 广播发送抽奖消息
     * @param raffleDto 抽奖详情dto
     */
    void sendRaffleMessage(RaffleDto raffleDto);

    /**
     * 向主播推送开奖消息
     */
    void sendDrawMessage(RaffleDto raffleDto);

    /**
     * 广播发送取消抽奖消息
     * @param raffleDto 抽奖详情dto
     */
    void sendCancelRaffleMessage(RaffleDto raffleDto);

    /**
     * 发送点赞Socket
     *
     * @param liveRoomId 直播间ID
     */
    void sendLike(Long liveRoomId);

    /**
     * 查询用户近30天/全部的 评论数，订阅直播
     * @param liveStatisticalParam 直播数据统计
     * @return 直播数据
     */
    LiveStatisticalResult liveInfoStatistical(LiveStatisticalParam liveStatisticalParam);

    /**
     * 直播统计-订阅来源
     * @param liveRoomId 直播间ID
     */
    List<InviteSubResult> liveSubStatistical(Long liveRoomId);

    /**
     * 订阅详情
     * @param pageSize 大小
     * @param liveRoomId 直播间ID
     * @param startLimit 开始页
     * @param source 来源
     * @return list
     */
    List<LiveUserFollowDto> subList(Long liveRoomId, Byte source, Integer pageSize, Integer startLimit);

    /**
     * 订阅统计
     * @param liveRoomId 直播间ID
     * @param source 来源
     */
    Integer subCount(Long liveRoomId, Byte source);

    /**
     * 直播观看时长统计
     * @param liveRoomId 直播间ID
     * @return 直播观看列表
     */
    List<LiveWatchExtDto> selectByWatchExt(Long liveRoomId);

    /**
     * 向主播发送付款失败消息
     * @param redpackDto 红包详情dto
     */
    void sendPaymentFailedMessage(RedpackDto redpackDto);

    /**
     * 发送红包发放完成消息
     */
    void sendRedpackDistributionCompletedMessage(RedpackDto redpackDto);

    /**
     * 发送用户领取红包消息
     */
    void sendRedpackReceiveMessage(RedpackDto redpackDto, String nickName,Long userId);

    /**
     * 查询商户就近一场直播间
     * @param merchantId 商户ID
     * @return 直播信息
     */
    LiveRoomDto selectByMerchantLiveNearby(Long merchantId);

    /**
     * 查询商户的本月直播统计
     */
    Integer selectLiveMonthCount(Long merchantId);

    /**
     * 本月直播数据和直播人数
     */
    HomePageResult selectByMonthLive(Long merchantId);

    /**
     * 关闭直播间
     * @param liveRoomId 直播间Id
     */
    void liveEnd(Long liveRoomId);

    /**
     * 定时任务-自动断流
     */
    void autoBreakStream();

    /**
     * 直播间数据详情
     * @param liveRoomId 直播间ID
     * @return 直播结果数据
     */
    LiveDescStatisticalResult getLiveStatistical(Long liveRoomId);

    /**
     * 直播商品列表
     */
    PageResult<LiveGoodsDataResult> selectByLiveGoodsPage(LiveGoodsPageRequest liveGoodsPageRequest);

    /**
     * 直播场次统计
     */
    List<LiveStatisticalDataResult> selectLiveStatistical(String startTime, String endTime);

    /**
     * 直播场次统计-年
     */
    List<LiveStatisticalDataResult> selectLiveStatisticalYear(String startTime, String endTime);

    /**
     * 直播当前商户统计-天
     */
    LiveStatisticalDescDataResult selectLiveStatisticalDesc(LiveDayRequest liveDayRequest);

    /**
     * 直播当前商户统计-月
     */
    LiveStatisticalDescDataResult selectLiveStatisticalMonthDesc(LiveDayRequest liveDayRequest);

    /**
     * 直播当前商户统计-年
     */
    LiveStatisticalDescDataResult selectLiveStatisticalYearDesc(LiveDayRequest liveDayRequest);

    /**
     * 管理后台:直播间详情-截图
     */
    PageResult<PageScreenshotResult> screenshotList(LiveScreenRequest liveScreenRequest);

    /**
     * 每小时检查直播是否过期
     */
    void liveExpiredJob();

    /**
     * 根据JOB状态查询所有的jobId
     *
     * @param jobStatus jobStatus
     * @return List<MpsJobDto>
     */
    List<MpsJobDto> mpsJobIdList(Byte jobStatus);

    /**
     * 查询Job看是否操作完成
     *
     * @param job job
     */
    void liveMpsJob(MpsJobDto job);

    /**
     * 根据短视频生成状态
     *
     * @param liveRoomDto liveRoomDto
     * @return List<LiveRoomDto>
     */
    List<LiveRoomDto> selectByRoomCondition(LiveRoomDto liveRoomDto);

    /**
     * 生成短视频
     *
     * @param liveRoomDto liveRoomDto
     */
    void genVideo(LiveRoomDto liveRoomDto);
}
