package com.jiamai.live.api.request;

import com.jiamai.live.api.enums.EnumDirectional;
import com.jiamai.live.api.enums.EnumPushType;
import com.jiamai.live.api.enums.EnumRecordStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.youqian.api.enums.TrueOrFalseEnum;
import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/18
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CreateRoomRequest extends Operator implements Serializable {

    @ApiModelProperty(value = "直播间名称", required = true)
    private String roomName;

    @ApiModelProperty(value = "直播封面", required = true)
    private String cover;

    @ApiModelProperty(value = "推流方式，1-小程序推流(默认)/2-第三方推流")
    private Byte pushType = EnumPushType.MINI_PUSH.getCode();

    @ApiModelProperty(value = "预计开播时间, 格式：yyyy-MM-dd HH:mm", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date expectOpenTime;

    @ApiModelProperty(value = "商品ID列表", required = true)
    private List<Long> goodsIdList;

    @ApiModelProperty("是否定向直播，0-非定向/1-定向")
    private Byte directional = EnumDirectional.NOT_DIRECT.getCode();

    @ApiModelProperty("直播录像状态，0-未公开/1-公开")
    private Byte recordStatus = EnumRecordStatus.NOT_OPEN.getCode();

    @ApiModelProperty("商品展示类型，0-默认/1-陆续揭幕")
    private Byte goodsShowType;

    @ApiModelProperty("直播间是否隐藏昵称，0-否/1-是")
    private Byte hideName;

    /**
     * 是否测试直播
     */
    private Byte testLive = TrueOrFalseEnum.FALSE.getCode().byteValue();

    /**
     * 微信OpenId
     */
    private              String        openId;
}
