package com.jiamai.live.api.request;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/5/14
 * @description
 */
@Data
public class LiveApplyRequest implements Serializable {

    /**
     * 直播间ID
     */
    @Min(1)
    @NotNull
    private Long liveRoomId;

    /**
     * 用户ID（前端忽略）
     */
    private Long userId;

    /**
     * 申请人微信昵称（前端忽略）
     */
    private String userName;

    /**
     * 用户头像（前端忽略）
     */
    private String avatarUrl;

    /**
     * 用户手机号码（前端忽略）
     */
    private String mobile;

    /**
     * 申请人名称
     */
    @NotBlank
    private String applyUserName;

    /**
     * 申请人企业名称
     */
    private String applyEnterpriseName;

    /**
     * 申请理由
     */
    @NotBlank
    private String applyReason;
}
