package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author xiachenhang
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveRoomFollowRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;
    
    @ApiModelProperty(value = "当前直播间ID", required = true)
    private Long operatorLiveRoomId;

    @ApiModelProperty(value = "订阅状态 0-取消提醒,1-提醒", required = true)
    private Integer status;

    @ApiModelProperty(value = "分享人ID", required = true)
    private Long shareUserId;

    @ApiModelProperty(value = "来源", required = true)
    private Byte source;

    /**
     * 微信OpenId
     */
    private              String        openId;

}
