package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/5/19
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OutRoomRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "观看ID（进入直播间返回的ID）", required = true)
    private Long liveWatchId;

    @ApiModelProperty(value = "用户名称（前端忽略）")
    private String userName;

    @ApiModelProperty("用户头像")
    private String avatarUrl;

}
