package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/8/26
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PreCommentRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @ApiModelProperty("查询afterLivePreCommentId之后的数据")
    private Long afterLivePreCommentId;

    @ApiModelProperty("查询beforeLivePreCommentId之前的数据")
    private Long beforeLivePreCommentId;

    @ApiModelProperty("查询的条数（默认查询全部）")
    private Integer count;
}
