package com.jiamai.live.api.request;

import com.youqian.api.request.PageRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/5/29
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RoomBuyerPageRequest extends PageRequest implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "商户ID", required = true)
    private Long merchantId;

    @ApiModelProperty("用户手机号（前端忽略）")
    private String mobile;

    @ApiModelProperty(value = "用户ID（前端忽略）")
    private Long userId;

    @ApiModelProperty("直播状态")
    private List<Byte> roomStatus;

}
