package com.jiamai.live.api.request;

import com.youqian.api.request.Operator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/7/24
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SwitchHotRequest extends Operator implements Serializable {

    @NotNull(message = "直播间ID不能为空")
    @Min(value = 1, message = "直播间ID必须大于0")
    @ApiModelProperty(value = "直播间ID", required = true)
    private Long liveRoomId;

    @NotNull(message = "商品序号不能为空")
    @Min(value = 1, message = "商品序号必须大于0")
    @ApiModelProperty(value = "商品序号", required = true)
    private Integer num;

    @NotNull(message = "liveHot不能为空")
    @Max(value = 1, message = "liveHot必须为0或1")
    @Min(value = 0, message = "liveHot必须为0或1")
    @ApiModelProperty(value = "是否爆品,0-不是(关)/1-是(开)", required = true)
    private Byte liveHot;
}
