package com.jiamai.live.api.result;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@Data
public class BuyerRoomEndResult implements Serializable {

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺Logo
     */
    private String storeLogo;

    /**
     * 直播时长
     */
    private String liveDuration;

    /**
     * 我的收藏数量
     */
    private Integer myCollectCount = 0;

    /**
     * 我的询价数量
     */
    private Integer myPriceAskCount = 0;

    /**
     * 观看人次
     */
    private Integer watchPv;

    /**
     * 是否有回放
     */
    private Boolean hasRecord;

    /**
     * 回放链接
     */
    private String recordUrl;

    /**
     * 模板ID
     */
    private List<String> templateIds;

    /**
     * 直播状态
     */
    private Byte recordStatus;

    /**
     * 视频回放生成状态, 0-未生成/1-直播回放已生成/2-直播回放+短视频已生成
     */
    private Byte recordGenStatus;

    /**
     * 回放视频长度
     */
    private Integer recordDuration;

}
