package com.jiamai.live.api.result;

import com.jiamai.live.api.dto.live.RealTimeDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@Data
public class LiveDataStatisticalResult implements Serializable {
    /**
     * 直播时长
     * max length = 20
     * not null default =
     */
    private String liveTime;

    /**
     * 观看的人次
     * not null default = 0
     */
    private Integer watchPv;

    /**
     * 观看人数
     * not null default = 0
     */
    private Integer watchUv;
    /**
     * 直播商品数
     * not null default = 0
     */
    private Integer liveGoodsTotal;

    /**
     * 人均观看时长: 总观看时长/观看人数
     * max length = 10
     * not null default =
     */
    private String watchTimeAverage;

    /**
     * 最高在线人数
     * not null default = 0
     */
    private Integer watchHighestUv;

    /**
     * 互动人数，评论+红包+抽奖
     * not null default = 0
     */
    private Integer interaction;

    /**
     * 抽奖人数
     * not null default = 0
     */
    private Integer raffle;

    /**
     * 红包人数
     * not null default = 0
     */
    private Integer redPacket;

    /**
     * 评论人数
     * not null default = 0
     */
    private Integer liveComment;
    /**
     * 统计状态: 1.直播未结束 2.直播结束
     * not null default = 0
     */
    private Byte status;
    /**
     * 累计评论
     * not null default = 0
     */
    private Integer commentTotal;

    /**
     * 点赞人数
     * not null default = 0
     */
    private Integer liveLike;

    /**
     * 点赞总数
     * not null default = 0
     */
    private Integer liveLikeTotal;

    /**
     * 发送红包次数
     * not null default = 0
     */
    private Integer sendRedPacket;

    /**
     * 发送抽奖次数
     * not null default = 0
     */
    private Integer sendRaffle;

    /**
     * 观看分析
     * max length = 200
     * not null default =
     */
    private List<RealTimeDto> realTime = Collections.emptyList();

    /**
     * 观看来源
     * max length = 200
     * not null default =
     */
    private List<WatchSource> watchSources = Collections.emptyList();

}
