package com.jiamai.live.api.result;

import com.jiamai.live.api.dto.live.RealTimeDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@Data
public class LiveDescStatisticalResult implements Serializable {
    /**
     * 结束时间
     */
    private String endTime;
    /**
     * 开播时间
     */
    private String realBeginTime;
    /**
     * 直播名
     */
    private String liveName;
    /**
     * 直播海报
     */
    private String cover;
    /**
     * 直播二维码
     */
    private String qrCode;
    /**
     * 商户名
     */
    private String merchantName;
    /**
     * 商户ID
     */
    private Long merchantId;
    /**
     * 主播名
     */
    private String liveUserName;
    /**
     * 主播头像
     */
    private String liveAvatar;
    /**
     * 标签:本月第N场
     */
    private String liveTag;
    /**
     * 总到场(UV)
     */
    private Integer uv;
    /**
     * 累计PV(PV)
     */
    private Integer pv;
    /**
     * 邀约数
     */
    private Integer invite;
    /**
     * 订阅数
     */
    private Integer sub;
    /**
     * 人均观看时长
     */
    private String watchTimeAverage;
    /**
     * 回看UV
     */
    private Integer backUv;
    /**
     * 人均回看时长
     */
    private String backAverage;
    /**
     * 观看分析
     * max length = 200
     * not null default =
     */
    private List<RealTimeDto> realTime = Collections.emptyList();

}
