package com.jiamai.live.api.result;

import com.jiamai.live.api.enums.EnumPushType;
import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/24
 * @description
 */
@Data
public class LivePermissionResult implements Serializable {

    /**
     * 能否直播
     * 0-能创建
     * 1-名片未完善
     * 2-正在进行直播
     */
    private Byte permissionCode;

    /**
     * 正在进行直播的直播间ID
     */
    private Long liveRoomId;

    /**
     * 推流方式，1-小程序推流/2-第三方推流
     */
    private Byte pushType = EnumPushType.MINI_PUSH.getCode();

}
