package com.jiamai.live.api.result;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/4/18
 * @description
 */
@Data
public class LiveRoomResultV2 implements Serializable {

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 创建用户ID
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 用户头像
     */
    private String avatarUrl;

    /**
     * 直播间名称
     */
    private String roomName;

    /**
     * 直播封面
     * max length = 200
     * not null default =
     */
    private String cover;

    /**
     * 直播间小程序二维码
     * max length = 200
     * not null default =
     */
    private String qrCode;

    /**
     * 直播间状态，1-直播完成/2-未开播/3-直播中
     */
    private Byte roomStatus;

    /**
     * 直播间状态文本
     */
    private String roomStatusText;

    /**
     * 直播间列表时间文案。待开播返回预计开播时间，直播中和已结束返回实际开播时间。
     */
    private Date openTimeText;

    /**
     * 预计开播时间
     * not null default = null
     */
    private Date expectOpenTime;

    /**
     * 实际开播时间
     */
    private Date realOpenTime;

    /**
     * 实际关播时间
     */
    private Date realCloseTime;

    /**
     * 订阅人数
     */
    private Integer subscribeCount = 0;

    /**
     * 观看人数
     */
    private Integer watchCount = 0;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否定向直播0-非定向/1-定向
     * 默认0
     */
    private Byte directional;

    /**
     * 是否有回放
     */
    private Boolean hasRecord;

    /**
     * 最热门 1-最热门 0-非最热门
     */
    private Integer maxHot = 0;

    /**
     * 直播时长（文本）
     */
    private String liveDuration;

    /**
     * 直播时长(秒)
     */
    private Long liveDurationSeconds;

    /**
     * 踢人，1-被踢了/0-没被踢
     */
    private Integer kickOff;

    /**
     * 推流方式，1-小程序推流/2-第三方推流
     */
    private Byte pushType;

    /**
     * 主播ID
     */
    private Long liverUserId;

    /**
     * 主播用户名称
     */
    private String liverUserName;

    /**
     * 主播头像
     */
    private String liverAvatarUrl;

    /**
     * 是否已经订阅
     */
    private Boolean alreadySubscribe = false;
}
