package com.jiamai.live.api.result;

import com.jiamai.live.api.dto.live.LiveAssistDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/20
 * @description
 */
@Data
public class RoomDetailResult implements Serializable {

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺Logo
     */
    private String storeLogo;

    /**
     * 创建用户ID
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String userName;

    /**
     * 创建人头像
     */
    private String avatarUrl;

    /**
     * 直播间名称
     */
    private String roomName;

    /**
     * 直播封面ID
     * max length = 200
     * not null default =
     */
    private String cover;

    /**
     * coverId
     */
    private String coverId;

    /**
     * 直播间小程序二维码
     * max length = 200
     * not null default =
     */
    private String qrCode;

    /**
     * 直播间状态，1-直播完成/2-未开播/3-直播中
     */
    private Byte roomStatus;

    /**
     * 直播间状态文本
     */
    private String roomStatusText;

    /**
     * 预计开播时间
     * not null default = null
     */
    private Date expectOpenTime;

    /**
     * 实际开播时间
     */
    private Date realOpenTime;

    /**
     * 实际关播时间
     */
    private Date realCloseTime;

    /**
     * 订阅人数
     */
    private Integer subscribeCount = 0;

    /**
     * 观看人数
     */
    private Integer watchCount = 0;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 商品详情
     */
    private List<LiveGoodsResult> goodsList = Collections.emptyList();

    /**
     * 商品数量
     */
    private Integer goodsCount = 0;

    /**
     * 是否展示分享直播间海报
     */
    private Boolean shareRoomPoster;

    /**
     * 是否展示邀请好友按钮
     */
    private Boolean inviteFriends;

    /**
     * 是否展示开始直播按钮
     */
    private Boolean startRoom;

    /**
     * 直播开始时长，单位秒
     */
    private Integer openSeconds;

    /**
     * 直播间人数
     */
    private String personCount;

    /**
     * 评论次数
     * not null default = 0
     */
    private Integer commentCount;

    /**
     * 清晰度
     */
    private String clarity;

    /**
     * 是否定向直播0-非定向/1-定向
     * 默认0
     */
    private Byte directional;

    /**
     * 1-是该直播间的助手
     * 0-不是该直播间的助手
     */
    private Integer assist = 0;

    /**
     * 助手昵称
     */
    private String assistNickName;

    /**
     * 直播录像状态，0-未公开，1-已公开
     */
    private Byte recordStatus;

    /**
     * 推流方式，1-小程序推流/2-第三方推流
     */
    private Byte pushType;

    /**
     * 是否是主播
     * 1-是该直播间的主播
     * 0-不是该直播间的主播
     */
    private Integer liver;

    /**
     * 直播间公告
     */
    private String announcement;

    /**
     * 直播间公告背景色
     */
    private String announcementBackgroundColor;

    /**
     * 用户头像列表
     */
    private List<String> userAvatarList;

    /**
     * 观看人数
     */
    private Integer watchPerson;

    /**
     * 是否员工
     */
    private Byte isEmployee = 0;


    /**
     * 商品展示类型，0-默认/1-陆续揭幕
     */
    private Byte goodsShowType;

    /**
     * 是否测试直播 1是
     */
    private Byte testLive;

    /**
     * 主播信息
     */
    private LiverResult liverInfo;

    /**
     * 助手列表
     */
    private List<LiveAssistResult> assistList;

    /**
     * 直播间是否隐藏昵称，0-否/1-是
     */
    private Byte hideName;
}
