package com.jiamai.live.api.result;

import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@Data
public class RoomEndResult implements Serializable {

    /**
     * 直播时长
     */
    private String liveDuration;

    /**
     * 商户名称
     */
    private String merchantName;

    /**
     * 直播时长(秒)
     */
    private Long liveDurationSeconds;

    /**
     * 观看人次
     */
    private Integer watchCount;

    /**
     * 观看人数
     */
    private Integer watchUv;

    /**
     * 店铺名片图
     */
    private String logo;

    /**
     * 直播封面图
     */
    private String cover;

    /**
     * 评论人数
     */
    private Integer commentCount;

    /**
     * 询价次数
     */
    private Integer priceAskCount;

    /**
     * 收藏次数
     */
    private Integer collectCount;

    /**
     * 邀约来访
     */
    private Integer invite;

    /**
     * 新访客
     */
    private Integer firstPerson;

    /**
     *人均观看
     */
    private String averageWatch;

    /**
     * 在线峰值
     */
    private Integer heightWatch;

    /**
     * 是否有回放
     */
    private Boolean hasRecord;

    /**
     * 直播录像状态，0-未公开，1-已公开
     */
    private Byte recordStatus;

    /**
     * 回放次数
     */
    private Integer watchBack = 0;

    /**
     * 视频回放生成状态, 0-未生成/1-直播回放已生成/2-直播回放+短视频已生成
     */
    private Byte recordGenStatus;

    /**
     * 回放视频长度
     */
    private Integer recordDuration;

}
