package com.jiamai.live.api.result;

import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/21
 * @description
 */
@Data
public class RoomStatusResult implements Serializable {

    /**
     * 是否观众
     *
     * 0-不是
     * 1-是
     */
    private Byte visitor;

    /**
     * 直播间状态
     * -1-直播间不存在
     * 0-已取消
     * 1-已结束
     * 2-待开播
     * 3-直播中
     */
    private Byte roomStatus;

    /**
     * 1-无需申请
     * 2-未申请客户
     * 3-申请被拒绝客户
     * 4-申请通过客户（废弃）
     * 5-申请中客户
     */
    private Integer customerType;

    /**
     * 是否是助手
     * 0-否
     * 1-是
     */
    private Integer assist;

    /**
     * 是否被踢
     */
    private Integer kickOff;

    /**
     * 推流方式，1-小程序推流/2-第三方推流
     */
    private Byte pushType;

    /**
     * 是否是主播
     * 1-是该直播间的主播
     * 0-不是该直播间的主播
     */
    private Integer liver;

    /**
     * 是否员工
     * 1-员工
     * 0-不是员工
     */
    private Integer employee;

    /**
     * 是否管理员
     * 1-管理员
     * 0-不是
     */
    private Integer manager;

    /**
     * 视频回放生成状态, 0-未生成/1-直播回放已生成/2-直播回放+短视频已生成
     */
    private Byte recordGenStatus;

    /**
     * 直播录像状态，0-未公开，1-已公开
     */
    private Byte recordStatus;

}
