package com.jiamai.live.api.result.websocket;

import lombok.Data;

import java.security.Principal;
import java.util.Date;

/**
 * Created by hong on 2020-04-20.
 * 用户权限信息
 */
@Data
public class UserPrincipal implements Principal {
    /**
     * 直播用户ID
     */
    private Long userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 失效时间. 执行加密算法时自动填充
     */
    private Date disableTime;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 分享人ID
     */
    private Long shareUserId;

    /**
     * 用户手机号
     */
    private String mobile;

    /**
     * 头像
     */
    private String avatarUrl;

    /**
     * 是否访客
     */
    private Byte isVisitor;

    /**
     * session的唯一建。很重要。目前为： 直播ID + 用户ID。
     *
     * @return
     */
    @Override
    public String getName() {
        return liveId + "_" + userId;
    }

}
