package com.jiamai.live.api.vo.websocket;

import com.jiamai.live.api.enums.EnumBanComment;
import lombok.Data;

import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/4/22
 * @description
 */
@Data
public class CommentResult implements UserNameResult, Serializable {

    /**
     * 评论ID
     */
    private Long liveCommentId;

    /**
     * 评论人ID
     */
    private Long userId;

    /**
     * 评论人名称
     */
    private String userName;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 企业
     */
    private String enterpriseName;

    /**
     * 头像
     */
    private String avatarUrl;

    /**
     * 评论内容
     */
    private String comment;

    /**
     * 是否禁言0-未禁言/1-已禁言
     */
    private Byte banComment = EnumBanComment.NOT_BAN.getCode();

}
