package com.jiamai.live.api.vo.websocket;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by hong
 * time 2020/7/22.
 */
@Data
public class RedpackMsgVo {
    private Long redpackId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 发红包商户
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 发红包员工
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 红包金额
     * not null default = 0.0000
     */
    private BigDecimal amount;

    /**
     * 单个红包金额
     * not null default = 0.0000
     */
    private BigDecimal unitamount;

    /**
     * 红包个数
     * not null default = 0
     */
    private Integer total;

    /**
     * 红包剩余个数
     * not null default = 0
     */
    private Integer remain;

    /**
     * 发红包时间
     */
    private Date sendDate;

    /**
     * 是否随机金额
     * not null default = null
     */
    private Byte randomAmount;

    /**
     * 是否关注后参与
     * not null default = 0
     */
    private Byte followAfterRaffle;

    /**
     * 红包名
     * max length = 30
     * not null default = null
     */
    private String name;

    /**
     * 直播id
     * not null default = null
     */
    private Long liveId;

    /**
     * 几分钟后发红包
     */
    private Integer sendAfterMinutes;

    /**
     * 红包状态 0正在发放 1待发放  2发放完成  3取消发放
     * not null default = 0
     */
    private Byte status;

    /**
     * 红包结束发放时间
     */
    private Date endDate;

    /**
     * 倒计时
     */
    private Long countdown;

    /**
     * 当前时间
     */
    private Date currentTime;

    /**
     * 红包状态 0正在发放 1待发放  2发放完成  3取消发放
     * not null default = 0
     */
    private Byte redpackStatus;
}
