package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 直播的每帧截图
 * @author youqian mybatis generator 
 * 2020-12-02
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveFrameScreenshotDto implements Serializable {
    private static final long serialVersionUID = 16068949007034549L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播每帧截图
     * not null default = 0
     */
    private Long liveFrameScreenshotId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 播放的时间-秒（从1开始）
     * not null default = 0
     */
    private Long playTime;

    /**
     * 图片名
     * max length = 100
     * not null default = 
     */
    private String picName;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}