package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 直播后数据统计表
 * @author youqian mybatis generator 
 * 2020-09-09
 */
@Data
public class LiveReportStatisticalDto implements Serializable {
    private static final long serialVersionUID = 15996233089319239L;

    /**
     * 自增键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播数据统计表ID
     * not null default = 0
     */
    private Long liveReportStatisticalId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 邀请人数
     * not null default = 0
     */
    private Integer invite;

    /**
     * 邀请人数-通过海报
     * not null default = 0
     */
    private Integer invitePosters;

    /**
     * 邀请人数-通过卡片
     * not null default = 0
     */
    private Integer inviteCard;

    /**
     * 订阅人数
     * not null default = 0
     */
    private Integer subscribe;

    /**
     * 订阅人数-通过海报
     * not null default = 0
     */
    private Integer subscribePosters;

    /**
     * 订阅人数-通过卡片
     * not null default = 0
     */
    private Integer subscribeCard;

    /**
     * 销售统计:[{"userId:0,"invite":0,"subscribe":0}] 
     * max length = 5000
     * not null default = 
     */
    private String sellStatistical;

    /**
     * 直播时长
     * max length = 20
     * not null default = 
     */
    private String liveTime;

    /**
     * 观看的人次
     * not null default = 0
     */
    private Integer watchPv;

    /**
     * 观看人数
     * not null default = 0
     */
    private Integer watchUv;

    /**
     * 直播商品数
     * not null default = 0
     */
    private Integer liveGoodsTotal;

    /**
     * 人均观看时长: 总观看时长/观看人数
     * max length = 10
     * not null default = 
     */
    private String watchTimeAverage;

    /**
     * 最高在线人数
     * not null default = 0
     */
    private Integer watchHighestUv;

    /**
     * 新增关注
     * not null default = 0
     */
    private Integer follow;

    /**
     * 到场率, 直播中人数/总邀请人数
     * not null default = 0.00
     */
    private BigDecimal watchInviteRatio;

    /**
     * 订阅到场率, 直播中订阅人数/总订阅
     * not null default = 0.00
     */
    private BigDecimal watchSubscribeRatio;

    /**
     * 互动人数，评论+红包+抽奖
     * not null default = 0
     */
    private Integer interaction;

    /**
     * 抽奖人数
     * not null default = 0
     */
    private Integer raffle;

    /**
     * 红包人数
     * not null default = 0
     */
    private Integer redPacket;

    /**
     * 评论人数
     * not null default = 0
     */
    private Integer liveComment;

    /**
     * 报单数
     * not null default = 0
     */
    private Integer orderBill;

    /**
     * 报单人数
     * not null default = 0
     */
    private Integer orderBillUv;

    /**
     * 报单金额
     * not null default = 0.00
     */
    private BigDecimal orderBillPrice;

    /**
     * 商品收藏
     * not null default = 0
     */
    private Integer collect;

    /**
     * 性别占比：[{"m":"0.3","w":"0.7"}]
     * max length = 30
     * not null default = 
     */
    private String genderRatio;

    /**
     * 区域分布: [{"浙江杭州":12,"浙江台州"：10}]
     * max length = 200
     * not null default = 
     */
    private String area;

    /**
     * 统计状态: 1.直播未结束 2.直播结束
     * not null default = 0
     */
    private Byte status;

    /**
     * 截止时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date time;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 累计评论
     * not null default = 0
     */
    private Integer commentTotal;

    /**
     * 点赞人数
     * not null default = 0
     */
    private Integer liveLike;

    /**
     * 点赞总数
     * not null default = 0
     */
    private Integer liveLikeTotal;

    /**
     * 发送红包次数
     * not null default = 0
     */
    private Integer sendRedPacket;

    /**
     * 发送抽奖次数
     * not null default = 0
     */
    private Integer sendRaffle;

    /**
     * 观看分析
     * max length = 200
     * not null default = 
     */
    private String watchInterval;

    /**
     * 观看来源
     * max length = 200
     * not null default = 
     */
    private String watchSource;
}