package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 直播截图表
 * @author youqian mybatis generator 
 * 2020-11-12
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveScreenshotDto implements Serializable {
    private static final long serialVersionUID = 16051506771419292L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播截图
     * not null default = 0
     */
    private Long liveScreenshotId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 播放的时间-时间戳
     * not null default = 0
     */
    private Long playTime;

    /**
     * 讲解中的商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 0-直播中 1-回放
     * not null default = 0
     */
    private Byte actionType;

    /**
     * 直播录像ID
     * not null default = 0
     */
    private Long liveRecordId;

    /**
     * 录像截图的时间戳
     * not null default = 0
     */
    private Long liveRecordTime;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}