package com.jiamai.live.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 直播间断流记录表
 * @author youqian mybatis generator 
 * 2020-10-28
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveStreamBackLogDto implements Serializable {
    private static final long serialVersionUID = 16038675301139319L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 直播流状态ID
     * not null default = 0
     */
    private Long liveStreamBackLogId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 断流状态
     * not null default = 0
     */
    private Byte pushStreamSatatus;

    /**
     * 断流开始时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date pushBeginTime;

    /**
     * 断流结束时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date pushEndTime;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}