/*
 * Decompiled with CFR 0.152.
 */
package com.jiamai.live.api.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public enum WatchEnum {
    UN_KNOW(-1, "", null, null),
    THREE_LESS(0, "\u5c0f\u4e8e3\u5206\u949f", 0L, 179L),
    THREE_TEN(1, "3~10\u5206\u949f", 180L, 599L),
    TEN_MORE(2, "10\u5206\u949f\u4ee5\u4e0a", 600L, null),
    TEN_THIRD(3, "10~30\u5206\u949f", 600L, 1799L),
    THIRD_MORE(4, "30\u5206\u949f\u4ee5\u4e0a", 1800L, null),
    THIRD_SIX(5, "30~60\u5206\u949f", 1800L, 3599L),
    SIX_MORE(6, "60\u5206\u949f\u4ee5\u4e0a", 3600L, null);

    private byte type;
    private String msg;
    private Long min;
    private Long max;
    public static final Long T;
    public static final Long TS;

    private WatchEnum(byte type, String msg, Long min, Long max) {
        this.type = type;
        this.msg = msg;
        this.min = min;
        this.max = max;
    }

    public static WatchEnum get(Byte code) {
        if (code == null) {
            return UN_KNOW;
        }
        for (WatchEnum watchEnum : WatchEnum.values()) {
            if (!Objects.equals(watchEnum.getType(), code)) continue;
            return watchEnum;
        }
        return UN_KNOW;
    }

    public static List<WatchEnum> chooseTime(Long time) {
        ArrayList<WatchEnum> list = new ArrayList<WatchEnum>(5);
        list.add(THREE_LESS);
        list.add(THREE_TEN);
        if (time == null) {
            return list;
        }
        if (time < T) {
            list.add(TEN_MORE);
            return list;
        }
        if (time < TS) {
            list.add(TEN_THIRD);
            list.add(THIRD_MORE);
            return list;
        }
        list.add(TEN_THIRD);
        list.add(THIRD_SIX);
        list.add(SIX_MORE);
        return list;
    }

    public static byte getWatchType(Long liveTime, Long time) {
        if (time == null) {
            return UN_KNOW.getType();
        }
        List<WatchEnum> watchEnums = WatchEnum.chooseTime(liveTime);
        for (WatchEnum watchEnum : watchEnums) {
            if (!(watchEnum.getMax() == null ? time >= watchEnum.getMin() : watchEnum.getMax() != null && watchEnum.getMin() != null && time >= watchEnum.getMin() && time <= watchEnum.getMax())) continue;
            return watchEnum.getType();
        }
        return UN_KNOW.getType();
    }

    public byte getType() {
        return this.type;
    }

    public String getMsg() {
        return this.msg;
    }

    public Long getMin() {
        return this.min;
    }

    public Long getMax() {
        return this.max;
    }

    static {
        T = 1800L;
        TS = 3600L;
    }
}

