package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播间评论表
 * @author youqian mybatis generator 
 * 2020-04-18
 */
@Data
public class LiveCommentDto implements Serializable {
    private static final long serialVersionUID = 15871774117995109L;

    /**
     * 直播评论ID
     * not null default = 0
     */
    private Long liveCommentId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 内容
     * max length = 100
     * not null default = 
     */
    private String content;

    /**
     * 评论类型,1-普通评论,2-收藏商品,3-关注店铺,4-点赞,5-进入直播间,6-试一下
     * not null default = 0
     */
    private Byte commentType;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 用户名称
     */
    private String userName;
}