package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播间用户观看记录表
 * @author youqian mybatis generator 
 * 2020-04-18
 */
@Data
public class LiveWatchDto implements Serializable {
    private static final long serialVersionUID = 15871774118017896L;

    /**
     * 业务ID
     * not null default = 0
     */
    private Long liveWatchId;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 进入直播间时间
     * not null default = null
     */
    private Date inRoomTime;

    /**
     * 离开直播间时间
     */
    private Date outRoomTime;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 用户头像
     */
    private String avatarUrl;

    /**
     * 用户手机号码
     */
    private String mobile;

    /**
     * 1-从推送进入
     * 0-其他
     */
    private Byte inRoomLocation;
}