package com.jiamai.live.api.dto.live;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 阿里云MPS Job表
 * @author youqian mybatis generator 
 * 2020-12-02
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MpsJobDto implements Serializable {
    private static final long serialVersionUID = 16069006278932494L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 业务主键
     * not null default = 0
     */
    private Long mpsJobId;

    /**
     * 阿里云MPS jobId
     * max length = 100
     * not null default = 
     */
    private String jobId;

    /**
     * job类型，1-转码/2-截图
     * not null default = 0
     */
    private Byte jobType;

    /**
     * job状态，1-已提交/2-已成功/3-已失败/4-已取消
     * not null default = 0
     */
    private Byte jobStatus;

    /**
     * 失败信息
     * max length = 255
     * not null default = 
     */
    private String errorMessage;

    /**
     * 直播间ID
     * not null default = 0
     */
    private Long liveRoomId;

    /**
     * 商品ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}