package com.jiamai.live.api.dto.poster;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 直播分享海报数据
 * Created by hong
 * time 2020/5/26.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class LiveShareQrcodeDataDto {
    /**
     * 商户名
     */
    private String  merchantName;

    /**
     * 海报二维码
     */
    private String  qrCode;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 昵称
     * not null default = null
     */
    private String  nickname;

    /**
     * 预计开播时间
     * not null default = null
     */
    private Date    expectOpenTime;

    /**
     * 直播间名称
     * max length = 20
     * not null default =
     */
    private String roomName;

    /**
     * 商户logo
     */
    private String  logo;

    /**
     * 观看人次
     */
    private Integer pv;

    /**
     * 直播封面
     * max length = 200
     * not null default =
     */
    private String cover;
}
