package com.jiamai.live.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/11/24.
 */
@Getter
public enum CommentTemplateTypeEnum {

    ASSISTANT(1, "assistant", "助手模板"),
    AUDIENCE_FIRST_ENTRY(2, "audience_first_entry", "观众首次进入模板"),
    GENERAL_AUDIENCE(3, "generalAudience", "观众通用模板");

    private final Integer code;

    private final String  type;

    private final String  desc;

    CommentTemplateTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static CommentTemplateTypeEnum getByCode(Integer code) {
        return Stream.of(CommentTemplateTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(ASSISTANT);
    }

    public static CommentTemplateTypeEnum getByType(String type) {
        return Stream.of(CommentTemplateTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(ASSISTANT);
    }
}